#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dictionary.h"

dictionary_t *create_dictionary() {
    dictionary_t *dict = malloc(sizeof(dictionary_t));
    if (dict == NULL) {
        return NULL;
    }
    dict->root = NULL;
    dict->size = 0;
    return dict;
}

int dict_insert(dictionary_t *dict, const char *word) {
    node_t* ptr = dict->root;
    node_t* trail = ptr;
    // loops through tree finding lowest point where new node should be
    while (ptr != NULL){
        if(strcmp(word, ptr->word) < 0){
            trail = ptr;
            ptr = ptr->left;
        }else{
            trail = ptr;
            ptr = ptr->right;
        }
    }
    // creates a new node and sets it in the correct position
    // if dict is empty, trail will be null
    if (trail == NULL){
        dict->root = malloc(sizeof(node_t));
        trail = dict->root;
    }// else if word is less, word goes to the left of current node
    else if (strcmp(word, trail->word) < 0){
        trail->left = malloc(sizeof(node_t));
        trail = trail->left;
    }// else it goes to the right
    else{
        trail->right = malloc(sizeof(node_t));
        trail = trail->right;
    }
    // copies word to node
    strcpy(trail->word, word);
    // sets left and right nodes to nothing
    trail->left = NULL;
    trail->right = NULL;
    // increases dict size
    dict->size++;
    return 0;
}

int dict_find(const dictionary_t *dict, const char *query) {
    // creates node pointer and temp value to store strcmp results
    node_t* ptr = dict->root;
    int str_results = 0;
    // loops until no where to go
    while (ptr != NULL){
        // compares strings, if the same returns 1, less than moves left, greater moves right
        str_results = strcmp(query, ptr->word);
        if(str_results == 0){
            return 1;
        }else if (str_results < 0) {
            ptr = ptr->left;
        }else{
            ptr = ptr->right;
        }
    }
    return 0;
}

void dict_print_helper(node_t *ptr){
    // recursive helper to go through and print left node first then current then right
    if(ptr == NULL) return;
    dict_print_helper(ptr->left);
    printf("%s\n", ptr->word);
    dict_print_helper(ptr->right);
}

void dict_print(const dictionary_t *dict) {
    // performs DFS Inorder to print words in alpha order
    dict_print_helper(dict->root);
}

void dict_free_helper(node_t *ptr){
    // recursive helper to free tree. Goes through left branch first then right then current
    if (ptr == NULL) return;
    dict_free_helper(ptr->left);
    dict_free_helper(ptr->right);
    free(ptr);
}

void dict_free(dictionary_t *dict) {
    // performs DFS Postorder to free memory of all nodes
    dict_free_helper(dict->root);
    // frees actual dict object
    free(dict);

}

dictionary_t *read_dict_from_text_file(const char *file_name) {
    FILE* dict_file = fopen(file_name, "r");
    if (dict_file == NULL) return NULL;
    dictionary_t* new_dict = malloc(sizeof(dictionary_t));
    new_dict->root=NULL;
    new_dict->size = 0;
    char tmp[128];
    while(fscanf(dict_file,"%s", tmp) != EOF){
        dict_insert(new_dict, tmp);
    }
    fclose(dict_file);
    return new_dict;
}

void write_dict_to_text_file_helper(FILE* save_file, node_t* ptr){
    // recursive function to save dictionary using preorder
    // returns when it reaches end of branch
    if(ptr == NULL) return;
    // saves current node to file
    fprintf(save_file, "%s\n", ptr->word);
    // continues from left and right branch
    write_dict_to_text_file_helper(save_file, ptr->left);
    write_dict_to_text_file_helper(save_file, ptr->right);
}

int write_dict_to_text_file(const dictionary_t *dict, const char *file_name) {
    // Saves dictionary using DFS PreOrder
    FILE* save_file = fopen(file_name, "w");
    // returns if it cant open file
    if (save_file == NULL) return -1;
    // writes all the words to a text file
    write_dict_to_text_file_helper(save_file, dict->root);
    fclose(save_file);
    return 0;
}
